

'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(If left blank, owner will be admin)": "(Se lasciato vuoto, il proprietario sar\u00e0 admin)",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "(almeno {passwordMinLength} caratteri e includere  {passwordStrengthLevel} dei seguenti caratteri: numeri, lettere maiuscole, lettere minuscole e altri simboli speciali)",
    "(at least {placeholder} characters)": "(almeno {placeholder} caratteri)",
    "(current notification)": "(notifica corrente)",
    "(current version)": "(versione corrente)",
    "1 Year": "1 Anno",
    "1 cell copied": "1 cell copied",
    "1 filter": "1 filtro",
    "1 hidden property": "1 propriet\u00e0 nascosta",
    "1 month ago": "1 mese fa",
    "1 preset hidden property": "1 propriet\u00e0 nascosta preimpostata",
    "1 record selected": "1 record selected",
    "1 row is copied.": "1 row is copied.",
    "1 sort": "1 ordinamento",
    "1 week ago": "1 settimana fa",
    "3 days ago": "3 giorni fa",
    "30 Days": "30 Giorni",
    "7 Days": "7 Giorni",
    "A file is being uploaded. Are you sure you want to leave this page?": "Un file \u00e8 in fase di caricamento. Sei sicuro di voler lasciare questa pagina?",
    "A file with the same name already exists in this folder.": "Un file con lo stesso nome esiste gi\u00e0 in questa cartella.",
    "API Token": "API Token",
    "API token is copied to the clipboard.": "Il token API viene copiato negli appunti.",
    "About": "Informazioni su",
    "About Us": "Informazioni su di noi",
    "Abuse Content": "Contenuto abusivo",
    "Abuse Reports": "Abuse Reports",
    "Abuse Type": "Tipo Abuso",
    "Abuse report added": "Abuse report added",
    "Accept": "Accettare",
    "Accepted": "Accettato",
    "Accepted at": "Accettato il",
    "Accepter": "Approvatore",
    "Access Log": "Log degli accessi",
    "Access scope": "Ambito di accesso",
    "Accurate to minute": "Preciso al minuto",
    "Action": "Azioni",
    "Actions": "Azioni",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "Attiva l'utente immediatamente dopo la registrazione. Se deselezionato, un utente deve essere attivato dall'amministratore o tramite l'email di attivazione",
    "Activated": "Attivato",
    "Activated Users": "Utenti attivati",
    "Active": "Attivo",
    "Active Users": "Utenti attivi",
    "Activities": "Attivit\u00e0",
    "Add": "Aggiungi",
    "Add Admin": "Aggiungi Amministratore",
    "Add Admins": "Aggiungi Amministratori",
    "Add Library": "Aggiungi Libreria",
    "Add Member": "Aggiungi un membro",
    "Add Organization": "Aggiungi Organizzazione",
    "Add Terms and Conditions": "Aggiungi termini e condizioni",
    "Add User": "Aggiungi utente",
    "Add Wiki": "Aggingi Wiki",
    "Add admin": "Aggiungi amministratore",
    "Add auto expiration": "Aggiungi la scadenza automatica",
    "Add cover": "Add cover",
    "Add custom permission": "Aggiungi autorizzazione personalizzata",
    "Add group": "Add group",
    "Add group member": "Aggiungi membro al gruppo",
    "Add icon": "Add icon",
    "Add institution": "Aggiungi istituzione",
    "Add members": "Aggiungi membri",
    "Add new notification": "Aggiungi nuova notifica",
    "Add option": "Aggiungi opzione",
    "Add password protection": "Aggiungi la protezione password",
    "Add permission": "Aggiungi autorizzazione",
    "Add user": "Aggiungi utente",
    "Add view": "Aggiungi vista",
    "Added": "Aggiunto",
    "Added user {user}": "Utente {user} aggiunto",
    "Admin": "Amministratore",
    "Admin Login Logs": "Log degli accessi come amministratore",
    "Admin Logs": "Admin Logs",
    "Admin Operation Logs": "Log delle operazioni come amministratore",
    "Admin access": "Accesso amministratore",
    "Admins": "Amministratori",
    "Advanced": "Avanzato",
    "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.": "Dopo aver abilitato le propriet\u00e0 estese per i file, puoi aggiungere diverse propriet\u00e0 ai file, come collaboratori, data di scadenza del file, descrizione del file. \u00c8 inoltre possibile creare viste diverse per le propriet\u00e0 estese basate su file.",
    "All": "Tutto",
    "All Groups": "Tutti i Gruppi",
    "All Notifications": "Tutte le notifiche",
    "All Public Links": "Tutti i collegamenti pubblici",
    "All files uploaded": "Tutti i File caricati",
    "All records loaded": "All records loaded",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "Consenti nuove registrazioni utente. Deseleziona questa opzione per impedire a chiunque di creare un nuovo account.",
    "An integer that is greater than 0 or equal to -2.": "Un numero intero maggiore di 0 o uguale a -2.",
    "An integer that is greater than or equal to 0.": "Un numero intero maggiore o uguale a 0.",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "Un collegamento interno \u00e8 un collegamento a un file o una cartella a cui gli utenti possono accedere con autorizzazione di lettura al file o alla cartella.",
    "And": "And",
    "Anonymous User": "Utente Anonimo",
    "Another property has this property type": "Another property has this property type",
    "Another user is editing this file!": "Another user is editing this file!",
    "Anyone with the link": "Chiunque abbia il collegamento",
    "App Name": "Nome dell'app",
    "Are you sure to change group {placeholder} to department ?": "Sei sicuro di cambiare il gruppo {placeholder} in dipartimento?",
    "Are you sure to delete": "Sei sicuro di cancellare",
    "Are you sure to delete ": "Sei sicuro di eliminare?",
    "Are you sure to revoke access of user {placeholder} ?": "Sei sicuro di voler revocare l'accesso dell'utente {placeholder}?",
    "Are you sure you want to clear trash?": "Sei sicuro di voler svuotare il cestino?",
    "Are you sure you want to delete": "Sei sicuro di voler eliminare?",
    "Are you sure you want to delete %s ?": "Sei sicuro di voler eliminare %s ?",
    "Are you sure you want to delete WebDAV password?": "Sei sicuro di voler eliminare la password WebDAV?",
    "Are you sure you want to delete Wiki": "Sei sicuro di voler eliminare il Wiki",
    "Are you sure you want to delete the notification ?": "Are you sure you want to delete the notification ?",
    "Are you sure you want to delete the selected share link(s) ?": "Sei sicuro di voler eliminare il/i collegamento(i) di condivisione selezionati?",
    "Are you sure you want to delete the selected user(s) ?": "Sei sicuro di voler eliminare gli utenti selezionati?",
    "Are you sure you want to delete the share link?": "Sei sicuro di voler eliminare il link di condivisione?",
    "Are you sure you want to delete this page?": "Sei sicuro di voler eliminare questa pagina?",
    "Are you sure you want to delete {placeholder} ?": "Sei sicuro di voler eliminare {placeholder}?",
    "Are you sure you want to delete {placeholder} completely?": "Are you sure you want to delete {placeholder} completely?",
    "Are you sure you want to disconnect?": "Sei sicuro di volerti disconnettere?",
    "Are you sure you want to leave share Wiki": "Sei sicuro di voler abbandonare la condivisione del Wiki",
    "Are you sure you want to remove {placeholder} ?": "Are you sure you want to remove {placeholder} ?",
    "Are you sure you want to reset the password of {placeholder} ?": "Are you sure you want to reset the password of {placeholder} ?",
    "Are you sure you want to restore this library?": "Sei sicuro di ripristinare questa libreria?",
    "Are you sure you want to restore {placeholder}?": "Are you sure you want to restore {placeholder}?",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "Are you sure you want to revoke the admin permission of {placeholder} ?",
    "Are you sure you want to set {placeholder} as Admin?": "Are you sure you want to set {placeholder} as Admin?",
    "Are you sure you want to set {user_placeholder} inactive?": "Are you sure you want to set {user_placeholder} inactive?",
    "Are you sure you want to unlink this device?": "Sei sicuro di voler scollegare questo dispositivo?",
    "Are you sure you want to unpublish Wiki": "Sei sicuro di voler annullare la pubblicazione del Wiki?",
    "At server": "At server",
    "Audio": "Audio",
    "Audit Admin": "Amministratore di controllo",
    "Auth Token created": "Auth Token created",
    "Auth Token deleted": "Auth Token deleted",
    "Authenticated emails": "E-mail autenticate",
    "Authenticated users": "Utenti autenticati",
    "Auto deletion": "Cancellazione automatica",
    "Automatically delete files that are not modified within certain days:": "Elimina automaticamente i file che non vengono modificati entro determinati giorni:",
    "Avatar": "Avatar",
    "Avatar updated": "Avatar updated",
    "Avatar:": "Avatar:",
    "Back": "Indietro",
    "Basic": "Basic",
    "Bell Icon": "Bell Icon",
    "Besides Write permission, user can also share the library.": "Oltre all'autorizzazione alla scrittura, l'utente pu\u00f2 anche condividere la libreria.",
    "Branding": "Marcare",
    "Broken (please contact your administrator to fix this library)": "Interrotto (contattare l'amministratore per correggere questa libreria)",
    "By day": "By day",
    "By month": "By month",
    "By name ascending": "Per nome ascendente",
    "By name descending": "Per nome discendente",
    "By quarter": "By quarter",
    "By size ascending": "Per dimensione crescente",
    "By size descending": "Per dimensione decrescente",
    "By time ascending": "Per orario ascendente",
    "By time descending": "Per orario discendente",
    "By week": "By week",
    "By year": "By year",
    "Can not copy folder %(src)s to its subfolder %(des)s": "Impossibile copiare la cartella%(src)s alla sua sottocartella %(des)s",
    "Can not move folder %(src)s to its subfolder %(des)s": "Impossibile spostare la cartella %(src)s nella relativa sottocartella %(des)s",
    "Cancel": "Annulla",
    "Cancel All": "Cancella tutto",
    "Cannot move parent page to child page": "Cannot move parent page to child page",
    "Capture information": "Capture information",
    "Capture time": "Capture time",
    "Certificate": "Certificate",
    "Change": "Cambia",
    "Change Password": "Cambia Password",
    "Change Password of Library {placeholder}": "Modifica password della libreria {placeholder}",
    "Change cover": "Change cover",
    "Change group to department": "Cambia gruppo in dipartimento",
    "Change to department": "Change to department",
    "Changes": "Modifiche",
    "Checkbox": "Checkbox",
    "Choose date": "Scegli una data",
    "Clean": "Annulla",
    "Clean succeeded.": " La pulizia \u00e8 riuscita.",
    "Cleaned trash": "Cleaned trash",
    "Clear": "Cancella",
    "Clear Trash": "Svuota il Cestino",
    "Clear files in trash and history\uff1a": "Cancella i file nel cestino e nella cronologia:",
    "Clear selected": "Cancella selezionati",
    "Click to load more": "Click to load more",
    "Clients": "Clients",
    "Close": "Chiudi",
    "Close (Esc)": "Chiudi (Esc)",
    "Code": "Codice",
    "Collaborator": "Collaboratore",
    "Collapse all": "Collapse all",
    "Color space": "Color space",
    "Community Edition": "Edizione pubblica",
    "Compressed": "Compressed",
    "Configure Seafile": "Configure Seafile",
    "Configure your Identity Provider": "Configure your Identity Provider",
    "Confirm": "Conferma",
    "Confirm Password": "Conferma Password",
    "Confirm password": "Conferma la password",
    "Connect": "Connettere",
    "Contact Email": "Contatto Email",
    "Contact Email:": "Contatto Email:",
    "Contact Information": "Informazioni sui contatti",
    "Contact information is required.": "Le informazioni di contatto sono obbligatorie.",
    "Content Scan Records": "Content Scan Records",
    "Convert & Export": "Convert & Export",
    "Convert Wiki": "Convert Wiki",
    "Convert to Markdown": "Convert to Markdown",
    "Convert to docx": "Convert to docx",
    "Convert to sdoc": "Convert to sdoc",
    "Convert with ONLYOFFICE": "Convert with ONLYOFFICE",
    "Converting, please wait...": "Converting, please wait...",
    "Copied": "Copiato",
    "Copied link to clipboard": "Copied link to clipboard",
    "Copy": "Copia",
    "Copy failed": "Copy failed",
    "Copy link": "Copy link",
    "Copy selected": "Copia selezionati",
    "Copy selected item(s) to:": "Copia gli elementi selezionati su:",
    "Copy the IdP's certificate and paste it here. The certificate format is as follows:": "Copy the IdP's certificate and paste it here. The certificate format is as follows:",
    "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.": "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.",
    "Copy {num} items": "Copia {num} elementi",
    "Copy {placeholder} to": "Copia {placeholder} in",
    "Copyright Infringement": "Violazione del diritto d'autore",
    "Count": "Conta",
    "Cover": "Cover",
    "Create": "Crea",
    "Create At": "Creato il",
    "Create Group": "Creare un gruppo",
    "Create Library": "Crea libreria",
    "Create Report": "Rapporto Creato",
    "Create a DNS TXT record to confirm the ownership of your Email Domain.": "Create a DNS TXT record to confirm the ownership of your Email Domain.",
    "Create a new tag": "Crea un nuovo tag",
    "Created": "Creato",
    "Created At": "Creato il",
    "Created Files": "File creati",
    "Created draft": "Bozza creata",
    "Created file": "File creato",
    "Created folder": "Cartella creata",
    "Created group {group_name}": "Gruppo {group_name} creato",
    "Created library": "Liberia creata",
    "Created library {library_name} with {owner} as its owner": "Libreria {library_name} creata con {owner} come suo proprietario",
    "Created time": "Created time",
    "Created {n} files": "Created {n} files",
    "Creator": "Creatore ",
    "Current Connected Devices": "Dispositivi Attualmente Connessi",
    "Current Library": "Libreria Corrente",
    "Current Path: ": "Percorso Attuale:",
    "Current Version": "Versione Corrente",
    "Current page": "Current page",
    "Current password": "Password corrente",
    "Current password cannot be blank": "La password attuale non pu\u00f2 essere vuota",
    "Current path: ": "Percorso corrente:",
    "Custom CSS": "CSS personalizzato",
    "Custom properties": "Propriet\u00e0 personalizzate",
    "Custom sharing permissions": "Autorizzazioni di condivisione personalizzate",
    "Customer Portal": "Portale clienti",
    "Customize URL": "Customize URL",
    "DNS TXT Value": "DNS TXT Value",
    "Daily Admin": "Amministratore giornaliero",
    "Database": "Database",
    "Date": "Data",
    "Date Invalid.": "data non valida.",
    "Day": "Day",
    "Default": "Predefinito",
    "Default Admin": "Amministratore predefinito",
    "Delete": "Elimina",
    "Delete Account": "Elimina Account",
    "Delete Department": "Dipartimento Rimosso",
    "Delete Expired Invitations": "Elimina inviti scaduti",
    "Delete File": "Rimuovi File",
    "Delete Folder": "Rimuovi Cartella",
    "Delete Group": "Elimina gruppo",
    "Delete Institution": "Elimina istituzione",
    "Delete Library": "Elimina libreria",
    "Delete Member": "Elimina membro",
    "Delete Notification": "Cancella Notifica",
    "Delete Organization": "Cancella l'organizzazione",
    "Delete Password": "Elimina password",
    "Delete T&C": "Delete T&C",
    "Delete Time": "Orario Cancellazione",
    "Delete User": "Elimina utente",
    "Delete Users": "Delete Users",
    "Delete WebDAV Password": "Elimina la password WebDAV",
    "Delete Wiki": "Rimuovi Wiki",
    "Delete file": "Delete file",
    "Delete files from this device the next time it comes online.": "Elimina i file da questo dispositivo la prossima volta che torni online.",
    "Delete folder": "Delete folder",
    "Delete group": "Delete group",
    "Delete page": "Delete page",
    "Delete property": "Delete property",
    "Delete selected": "Delete selected",
    "Delete share link": "Elimina il collegamento di condivisione",
    "Delete share links": "Elimina i collegamenti di condivisione",
    "Deleted": "Eliminato",
    "Deleted Libraries": "Librerie Eliminate",
    "Deleted Time": "Tempo di cancellazione",
    "Deleted directories": "Cartelle eliminate",
    "Deleted draft": "Bozza cancellata",
    "Deleted file": "File rimosso",
    "Deleted files": "File eliminati",
    "Deleted folder": "Cartella rimossa",
    "Deleted group {group_name}": "Gruppo {group_name} eliminato",
    "Deleted library": "Libreria Rimossa",
    "Deleted library {library_name}": "Libreria {library_name} rimossa",
    "Deleted option": "Deleted option",
    "Deleted user %s": "Deleted user %s",
    "Deleted user {user}": "Utente {user} eliminato",
    "Department renamed": "Department renamed",
    "Departments": "Dipartimenti",
    "Description": "Descrizione",
    "Description is required": "La Descrizione \u00e8 richiesta",
    "Desktop": "Desktop",
    "Detail": "Dettaglio",
    "Details": "Dettagli",
    "Device": "Dispositivo",
    "Device Name": "Nome Dispositivo",
    "Device make": "Device make",
    "Device model": "Device model",
    "Devices": "Dispositivi",
    "Dimensions": "Dimensions",
    "Direct download link": "Collegamento diretto per il download",
    "Direct download link is copied to the clipboard.": "Il collegamento per il download diretto viene copiato negli appunti.",
    "Disable SAML user email / password login": "Disable SAML user email / password login",
    "Disable Two-Factor Authentication": "Disabilita l'autenticazione a due fattori",
    "Disconnect": "Disconnetti",
    "Display files": "Display files",
    "Do not automatically delete files": "Non eliminare automaticamente i file",
    "Do you really want to turn off extended properties? Existing properties will all be deleted.": "Vuoi davvero disattivare le propriet\u00e0 estese? Le propriet\u00e0 esistenti verranno tutte eliminate.",
    "Document": "Document",
    "Document convertion failed.": "Conversione documento fallita.",
    "Document keywords": "Document keywords",
    "Domain verified": "Domain verified",
    "Don't ignore": "Don't ignore",
    "Don't keep history": "Non conservare la cronologia",
    "Don't replace": "Non sostituire",
    "Don't send emails": "Email non inviate",
    "Done": "Done",
    "Down": "Down",
    "Download": "Scarica",
    "Download an example file": "Scarica un file di esempio",
    "Download and upload": "Scarica e carica",
    "Duplicate": "Duplicate",
    "Duplicate page": "Duplicate page",
    "Edit": "Modifica",
    "Edit format settings": "Edit format settings",
    "Edit labels": "Modifica etichette",
    "Edit metadata properties": "Modifica le propriet\u00e0 dei metadati",
    "Edit multiple select": "Edit multiple select",
    "Edit on cloud and download": "Modifica nel Cloud e scarica",
    "Edit on cloud only": "Modifica solo sul cloud",
    "Edit permission": "Modifica permesso",
    "Edit single select": "Edit single select",
    "Edit succeeded": "Modifica eseguita",
    "Edit succeeded.": "Edit succeeded.",
    "Email": "Email",
    "Email Domain": "Email Domain",
    "Email Notification": "Notifica per Email",
    "Email is invalid.": " L'e-mail non \u00e8 valida.",
    "Email notification updated": "Email notification updated",
    "Emails": "E-mail",
    "Emails, separated by ','": "Email, separate da ','",
    "Emojis": "Emojis",
    "Empty": "Vuoto",
    "Enable Two-Factor Authentication": "Abilita autenticazione a due fattori",
    "Enable extended properties": "Abilita propriet\u00e0 estese",
    "Enable face recognition to identify people in your photos.": "Enable face recognition to identify people in your photos.",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "Abilitare l'amministratore di sistema per aggiungere termini e condizioni e tutti gli utenti dovranno accettare i termini.",
    "Enable two factor authentication": "Abilita l'autenticazione a due fattori",
    "Enable users to share libraries to any groups in the system.": "Consenti agli utenti di condividere le librerie con qualsiasi gruppo nel sistema.",
    "Encrypt": "Cifra",
    "Encrypted library": "Libreria crittografata",
    "End date": "Data di fine",
    "Enter characters to start searching": "Digita alcuni caratteri per avviare la ricerca",
    "Error": "Errore",
    "Errors": "Errori",
    "European": "Europea",
    "Exact date": "Data esatta",
    "Exit Institution Admin": "Esci dall'amministrazione dell'istituto",
    "Exit Organization Admin": "Esci dall'amministrazione dell'organizzazione",
    "Exit System Admin": "Uscita da Amministrazione di Sistema",
    "Expand all": "Expand all",
    "Expiration": "Scadenza",
    "Expiration date": "Data di scadenza",
    "Expiration days": "Giorni di scadenza",
    "Expiration time": "Tempo di scadenza",
    "Expired": "Scaduto",
    "Expired at": "Scaduro il",
    "Export": "Esportare",
    "Export Excel": "Esporta in Excel",
    "Export as docx": "Export as docx",
    "Export as zip": "Export as zip",
    "Export tags": "Esporta etichette",
    "Exporting": "Exporting",
    "Exporting...": "Exporting...",
    "Exposure time": "Exposure time",
    "Extended properties": "Propriet\u00e0 estese",
    "Extension Prompts": "Extension Prompts",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "Estensioni dei file di testo che possono essere visualizzati in anteprima online, ciascun suffisso \u00e8 separato da una virgola.",
    "Extract file detail": "Extract file detail",
    "Extract file details": "Extract file details",
    "F number": "F number",
    "Face recognition": "Face recognition",
    "Failed": "Fallito",
    "Failed imported options": "Failed imported options",
    "Failed to convert {name}.": "Failed to convert {name}.",
    "Failed to copy %(name)s": "Impossibile copiare %(name)s",
    "Failed to copy %(name)s and %(amount)s other item(s).": "Failed to copy %(name)s and %(amount)s other item(s).",
    "Failed to copy %(name)s.": "Failed to copy %(name)s.",
    "Failed to copy files to another library.": "Failed to copy files to another library.",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "Failed to delete %(virus_file) from library %(library): %(error_msg)",
    "Failed to delete property": "Failed to delete property",
    "Failed to delete records": "Failed to delete records",
    "Failed to delete {name}": "Failed to delete {name}",
    "Failed to delete {name} and {n} other items.": "Failed to delete {name} and {n} other items.",
    "Failed to delete {name}.": "Impossibile eliminare {name}.",
    "Failed to download. The total size of the files exceeded the limit.": "Impossibile scaricare. La dimensione totale dei file ha superato il limite.",
    "Failed to duplicate page": "Failed to duplicate page",
    "Failed to export. Please check whether the size of table attachments exceeds the limit.": "Impossibile esportare. Controlla se la dimensione degli allegati della tabella supera il limite.",
    "Failed to extract file details": "Failed to extract file details",
    "Failed to generate description": "Failed to generate description",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "Failed to ignore %(virus_file) from library %(library): %(error_msg)",
    "Failed to import tags. Please reupload.": "Impossibile importare le etichette. Per favore ricarica.",
    "Failed to insert property": "Failed to insert property",
    "Failed to modify filter": "Failed to modify filter",
    "Failed to modify group": "Failed to modify group",
    "Failed to modify hidden properties": "Failed to modify hidden properties",
    "Failed to modify people name": "Failed to modify people name",
    "Failed to modify property data": "Failed to modify property data",
    "Failed to modify property order": "Failed to modify property order",
    "Failed to modify records": "Failed to modify records",
    "Failed to modify sort": "Failed to modify sort",
    "Failed to move %(name)s and %(amount)s other item(s).": "Failed to move %(name)s and %(amount)s other item(s).",
    "Failed to move %(name)s.": "Failed to move %(name)s.",
    "Failed to move files to another library.": "Failed to move files to another library.",
    "Failed to move {name}.": "Failed to move {name}.",
    "Failed to rename property": "Failed to rename property",
    "Failed to restore records": "Failed to restore records",
    "Failed to restore {name}": "Failed to restore {name}",
    "Failed to restore {name} and {n} other items": "Failed to restore {name} and {n} other items",
    "Failed to save": "Failed to save",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "Impossibile inviare a {email_placeholder}: {errorMsg_placeholder}",
    "Failed to unshare {name}": "Failed to unshare {name}",
    "Failed to upload {file_name}.": "Failed to upload {file_name}.",
    "Failed. Please check the network.": "Errore. Si prega di verificare la configurazione di rete.",
    "Favorites": "Preferiti",
    "File": "File",
    "File Access": "Accesso ai file",
    "File Operations": "Operazioni sui file",
    "File Update": "Aggiornamento File",
    "File Upload": "Caricare un file",
    "File Uploading...": "Caricamento file...",
    "File already exists.": "Il File esiste gi\u00e0.",
    "File collaborators": "File collaborators",
    "File details": "File details",
    "File download is disabled: the share link traffic of owner is used up.": "File download disabilitato: la quota di traffico del collegamento per l'utente \u00e8 esaurita.",
    "File expire time": "File expire time",
    "File extension white list": "File extension white list",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.",
    "File extensions can only be {placeholder}.": "Le estensioni dei file possono essere solo {placeholder}.",
    "File is locked by others.": "Il file \u00e8 bloccato da altri.",
    "File name": "File name",
    "File owner": "File owner",
    "File reviewer": "File reviewer",
    "File size is too large.": "Dimensione del File troppo grande.",
    "File status": "File status",
    "File too large": "File troppo grande",
    "File type": "File type",
    "Files": "Documenti",
    "Files and folders": "Files and folders",
    "Filter": "Filtro",
    "Filters": "Filtri",
    "Find a tag": "Cerca una etichetta",
    "Find modifiers": "Find modifiers",
    "Focal length": "Focal length",
    "Fold the sidebar": "Nascondi la barra laterale",
    "Folder": "Cartella",
    "Folder Permission": "Permessi cartella",
    "Folder does not exist.": "La cartella non esiste.",
    "Folders": "Cartelle",
    "Force user to change password when account is newly added or reset by admin": "Forza l'utente a cambiare la password quando l'account viene aggiunto o ripristinato dall'amministratore",
    "Force user to use SSO login if SAML account is bound": "Force user to use SSO login if SAML account is bound",
    "Force user to use a strong password when sign up or change password.": "Forza l'utente a utilizzare una password complessa al momento della registrazione o modifica della password.",
    "Format": "Formato",
    "Freeze Document": "Freeze Document",
    "Freeze user account when failed login attempts exceed limit.": "Blocca l'account utente quando i tentativi di accesso falliti superano il limite.",
    "Frozen by {name}": "Congelato da {name}",
    "Gallery": "Gallery",
    "General information": "General information",
    "Generate": "Generare",
    "Generate Link": "Genera collegamento",
    "Generate description": "Generate description",
    "Generate links in batch": "Genera collegamenti in batch",
    "Generate share link": "Link di condivisione generico",
    "Germany Russia etc": "Germania Russia ecc.",
    "Global Address Book": "Rubrica globale",
    "Greater than or equal to {minDays_placeholder} days": "Maggiore o uguale a {minDays_placeholder} giorni",
    "Grid": "Griglia",
    "Grid view": "Visualizzazione griglia",
    "Group": "Condivise ai miei Gruppi",
    "Group Permission": "Permessi Gruppo",
    "Group Shares": "Condivisioni del Gruppo",
    "Group by": "Raggruppa per",
    "Group has been transfered": "Group has been transfered",
    "Group members": "Membri del gruppo",
    "Grouped by 1 property": "Raggruppati per 1 propriet\u00e0",
    "Groups": "Gruppi",
    "Guest": "Ospite",
    "Handled": "Mantenuto",
    "Help": "Aiuto",
    "Help and resources": "Aiuto e risorse",
    "Hide": "Nacondi",
    "Hide all": "Hide all",
    "Hide properties": "Nascondi propriet\u00e0",
    "History": "Cronologia",
    "History Setting": "Preferenze Storico",
    "History Versions": "Versioni cronologia",
    "IP": "IP",
    "ISO": "ISO",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "Se le notifiche non vengono lette entro un'ora, verranno inviate alla tua casella di posta.",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "Se attivi, i client desktop non saranno in grado di sincronizzare una cartella al di fuori della cartella predefinita Seafile.",
    "If you don't have any device with you, you can access your account using backup codes.": "Se non hai alcun dispositivo con te, puoi accedere al tuo account usando i codici di backup.",
    "Ignore": "Ignore",
    "Ignored": "Ignored",
    "Import Users": "Import Users",
    "Import members": "Import members",
    "Import members from a .xlsx file": "Importa membri da un file .xlsx",
    "Import options": "Import options",
    "Import sdoc": "Import sdoc",
    "Import tags": "Importa etichette",
    "Import users": "Importa utenti",
    "Import users from a .xlsx file": "Importa utente da un file .xlsx",
    "In progress": "In progress",
    "In review": "In review",
    "Inactive": "Inattivo",
    "Info": "Info",
    "Institution": "Istituzione",
    "Institution Admin": "Amministratore dell'Istituzione",
    "Institutions": "Istruzioni",
    "Internal Link": "Collegamento interno",
    "Internal Server Error": "Errore interno del server",
    "Internal link has been copied to clipboard": "Il collegamento interno \u00e8 stato copiato negli appunti",
    "Invalid destination path": "Percorso di destinazione non valido",
    "Invalid filename.": "Nome file invalido.",
    "Invalid filter": "Invalid filter",
    "Invalid month, should be yyyymm.": "Mese non valido, dovrebbe essere espresso nella forma aaaamm.",
    "Invalid regular expression": "Invalid regular expression",
    "Invisible": "Invisible",
    "Invitations": "Inviti",
    "Invite Guest": "Invita ospite",
    "Invite Time": "Tempo di Invito",
    "Invite users": "Invita utenti",
    "Invited at": "Invitato il",
    "Inviter": "Invitante",
    "Is expired": "Is expired",
    "It is required.": "\u00c8 richiesto.",
    "It may take some time, please wait.": "Potrebbe volerci del tempo, ti preghiamo di attendere.",
    "Keep full history": "Conserva la cronologia",
    "Keep sharing": "Keep sharing",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP(importato)",
    "Label": "Label",
    "Label Current State": "Etichetta Stato corrente",
    "Labels": "Etichette",
    "Language": "Lingua",
    "Language Setting": "Impostazioni Lingua",
    "Last Access": "Ultimo Accesso",
    "Last Login": "Ultimo Accesso",
    "Last Update": "Ultimo aggiornamento",
    "Last modified by": "Ultima modifica da",
    "Last modified time": "Ora dell'ultima modifica",
    "Last modifier": "Ultima modifica",
    "Leave": "Abbandona",
    "Leave Group": "Abbandona Gruppo",
    "Leave Share": "Lascia Condivisione",
    "Leave Share Wiki": "Abbandona Condivisione del Wiki",
    "Leave group": "Abbandona gruppo",
    "Leave this page? The system may not save your changes.": "Leave this page? The system may not save your changes.",
    "Less than or equal to {maxDays_placeholder} days": "Minore o uguale a {maxDays_placeholder} giorni",
    "Libraries": "Librerie",
    "Library": "Libreria",
    "Library Type": "Tipo di Libreria",
    "Library can not be shared to owner.": "La libreria non pu\u00f2 essere condivisa con il proprietario.",
    "Library share permission not found.": "Library share permission not found.",
    "Limits": "Limiti",
    "Link": "Link",
    "Link has been copied to clipboard": "Il link \u00e8 stato copiato negli appunti",
    "Linked Devices": "Dispositivi collegati",
    "Links": "Link",
    "List": "Elenco",
    "List view": "Visualizzazione elenco",
    "List your account in global address book, so that others can find you by typing your name.": "Elenca la rubrica globale del il tuo account, in modo che altri possano trovarti digitando il tuo nome.",
    "Load all": "Load all",
    "Loaded 50,000 records.": "Loaded 50,000 records.",
    "Loading": "Loading",
    "Location": "Posizione",
    "Lock": "Serratura",
    "Log out": "Termina Sessione",
    "Login": "Login",
    "Logo updated": "Logo updated",
    "Logs": "Logs",
    "Long text": "Testo lungo",
    "Manage group members": "Gestisci i membri del gruppo",
    "Manage members": "Manage members",
    "Mark all as read": "Contrassegna tutto come letto",
    "Mark all read": "Segna come letti",
    "Max": "Max",
    "Member": "Membro",
    "Members": "Membri",
    "Message": "Messaggio",
    "Message (optional):": "Messaggio (opzionale):",
    "Migrate User": "Migrate User",
    "Mobile": "Mobile",
    "Modification Details": "Dettaglio Modifiche",
    "Modified": "Modificato",
    "Modified by": "Modified by",
    "Modified by:": "Modified by:",
    "Modified files": "File modificati",
    "Modifier": "Modificatore",
    "Modify": "Modificare",
    "Modify includes modify file, move/rename file and folder": "Modifica include modificare file, spostare/rinominare file e cartelle",
    "Modify name": "Modify name",
    "Month": "Month",
    "Month:": "Mese:",
    "Monthly User Traffic": "Traffico utenti mensile",
    "More": "Altro",
    "More operations": "Altro",
    "Move": "Sposta",
    "Move selected item(s) to:": "Sposta gli oggetti selezionati su:",
    "Move {num} items": "Sposta {num} elementi",
    "Move {placeholder} to": "Sposta {placeholder} in",
    "Moved file": "File spostato",
    "Moved folder": "Cartella spostata",
    "Multiple select": "Selezione multipla",
    "My Libraries": "Le Mie Librerie",
    "My Wikis": "I miei Wiki",
    "Name": "Nome",
    "Name already exists": "Name already exists",
    "Name cannot be double dots": "Name cannot be double dots",
    "Name cannot be empty": "Name cannot be empty",
    "Name cannot contain backslash": " Il nome non pu\u00f2 contenere il carattere '\\'",
    "Name cannot contain backtick": "Name cannot contain backtick",
    "Name cannot contain curly braces": "Name cannot contain curly braces",
    "Name cannot contain dots": "Il nome non pu\u00f2 contenere punti",
    "Name cannot contain slash": " Il nome non pu\u00f2 contenere il carattere '/'",
    "Name is required": "Il nome \u00e8 obbligatorio",
    "Name is required.": "Il nome \u00e8 obbligatorio.",
    "Name or ID": "Name or ID",
    "Name should be string": "Il nome dovrebbe essere una stringa",
    "Name should not include '/'.": "Il nome non dovrebbe contenere '/'.",
    "Name updated": "Name updated",
    "Name(optional)": "Nome(opzionale)",
    "Network error": "Errore rete",
    "New": "Nuovo",
    "New Department": "Nuovo Dipartimento",
    "New Department Library": "Nuova libreria del dipartimento",
    "New Excel File": "Nuovo file Excel",
    "New File": "Nuovo File",
    "New Folder": "Nuova Cartella",
    "New Group": "Nuovo gruppo",
    "New Library": "Nuova libreria",
    "New Markdown File": "Nuovo file Markdown",
    "New Password": "Nuova Password",
    "New Password Again": "Nuova Password Controllo",
    "New PowerPoint File": "Nuovo file di PowerPoint",
    "New SeaDoc File": "Nuovo file SeaDoc",
    "New Sub-department": "Nuovo Sotto-dipartimento",
    "New Tag": "Nuovo Tag",
    "New Wiki name": "Nuovo nome del Wiki",
    "New Word File": "Nuovo file Word",
    "New directories": "Nuove cartelle",
    "New file name": "Nuovo nome file",
    "New files": "Nuovi file",
    "New folder name": "Nuovo nome cartella",
    "New page": "Nuova pagina",
    "New password": "Nuova password",
    "New password cannot be the same as old password": " La nuova password non pu\u00f2 essere uguale alla vecchia password",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": " La nuova password \u00e8 stata inviata alla tua email {mail}. Per favore controlla la tua casella di posta. Se non ricevi la password, controlla se il tuo indirizzo email \u00e8 configurato correttamente.",
    "New password is too short": "La nuova password \u00e8 troppo corta",
    "New passwords don't match": "Le nuove password non corrispondono",
    "New view": "New view",
    "Next": "Successivo",
    "Next (Right arrow key)": "Successivo (tasto freccia destra)",
    "No Admin login logs": "No Admin login logs",
    "No Admin operation logs": "No Admin operation logs",
    "No Wikis": "No Wikis",
    "No address found for the given coordinates.": "No address found for the given coordinates.",
    "No changes": "No changes",
    "No collaborators": "Nessun collaboratore",
    "No collaborators available": "Nessun collaboratore disponibile",
    "No connected devices": "Nessun dispositivo connesso",
    "No deleted libraries": "Nessuna libreria eliminata",
    "No favorites": "No favorites",
    "No file": "No file",
    "No file access logs": "No file access logs",
    "No file update logs": "No file update logs",
    "No filters": "No filters",
    "No folders shared": "No folders shared",
    "No groupings applied to this view.": "No groupings applied to this view.",
    "No groups": "Nessun gruppo",
    "No guest invitations": "No guest invitations",
    "No invitations": "No invitations",
    "No libraries": "Nessuna libreria",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.",
    "No libraries have been shared with you": "Nessuna librerie \u00e8 stata condivia con te",
    "No libraries have been shared with you from other servers.": "No libraries have been shared with you from other servers.",
    "No libraries shared": "No libraries shared",
    "No libraries shared with this group": "No libraries shared with this group",
    "No linked devices": "No linked devices",
    "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "Nessun dispositivo collegato. Non hai ancora effettuato l'accesso ai tuoi file con nessun client (desktop o mobile). Configura i client sui tuoi dispositivi per accedere ai tuoi dati pi\u00f9 comodamente.",
    "No login logs": "No login logs",
    "No members": "Nessun membro",
    "No more activities": "No more activities",
    "No notifications": "No notifications",
    "No option": "Nessuna opzione",
    "No options": "No options",
    "No options available": "Nessuna opzione disponibile",
    "No permission logs": "No permission logs",
    "No preview": "Nessuna anteprima",
    "No properties available to be hidden": "No properties available to be hidden",
    "No public libraries": "Nessuna libreria pubblica",
    "No record": "No record",
    "No result": "Nessun risultato",
    "No results": "No results",
    "No results matching": "Nessun risultato corrispondente",
    "No share links": "Nessun link di condivisione",
    "No sync errors": "Nessun errore di sincronizzazione",
    "No tags": "Nessun tag",
    "No terms and conditions": "No terms and conditions",
    "No upload links": "No upload links",
    "No users": "No users",
    "No version history": "No version history",
    "None": "Niente",
    "Not allow user to clean library trash": "Not allow user to clean library trash",
    "Not allow user to create encrypted libraries": "Not allow user to create encrypted libraries",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "Nota: le impostazioni tramite l'interfaccia web vengono salvate nella tabella del database (seahub-db/constance_config). Hanno una priorit\u00e0 pi\u00f9 alta rispetto alle impostazioni contenute dei file di configurazione",
    "Notification": "Notifica",
    "Notification Detail": "Dettagli di notifica",
    "Notifications": "Notifiche",
    "Notifications of collaboration": "Notifiche di collaborazione",
    "Notifications of file changes": "Notifiche delle modifiche ai file",
    "Number": "Numero",
    "Number of days ago": "Numero di giorni fa",
    "Number of days from now": "Numero di giorni da ora",
    "Number of days that keep user sign in.": "Numero di giorni in cui l'utente rimane connesso.",
    "Number of groups": "Numero di gruppi",
    "Number of links": "Numero di collegamenti",
    "Off": "Spento",
    "Old Password": "Vecchia Password",
    "Old Wikis": "Vecchi Wiki",
    "On": "Acceso",
    "One month ago": "Un mese fa",
    "One month from now": "Un mese da ora",
    "One week ago": "Una settimana fa",
    "One week from now": "Una settimana da ora",
    "Online Preview": "Anteprima Online",
    "Online Read-Only": "Online Read-Only",
    "Online Read-Only folder": "Online Read-Only folder",
    "Online Read-Only library": "Online Read-Only library",
    "Online Read-Write": "Online Read-Write",
    "Online Read-Write folder": "Online Read-Write folder",
    "Online Read-Write library": "Online Read-Write library",
    "Online view is not applicable to this file format": "La visualizzazione online non \u00e8 applicabile a questo formato di file",
    "Only Show": "Solo Visualizzazione",
    "Only files": "Only files",
    "Only folders": "Only folders",
    "Only keep a period of history:": "Tieni solamente un periodo della cronologia:",
    "Only pictures": "Only pictures",
    "Only videos": "Only videos",
    "Open file in new tab": "Apri il file in una nuova scheda",
    "Open folder in new tab": "Apri la cartella in una nuova scheda",
    "Open in new tab": "Open in new tab",
    "Open parent folder": "Apri cartella principale",
    "Open via Client": "Apri tramite Client ",
    "Operation": "Operazione",
    "Operation succeeded.": "Operazione conclusa con successo.",
    "Operations": "Operazioni",
    "Optional": "Opzionale",
    "Options imported": "Options imported",
    "Or": "Or",
    "Organization": "Organizzazione",
    "Organization Admin": "Amministratore dell'organizzazione",
    "Organizations": "Organizzazioni",
    "Original path": "Percorso originale",
    "Other": "Altro",
    "Other Libraries": "Altre Librerie",
    "Others": "Altri",
    "Out of quota.": "Quota superata.",
    "Outdated": "Outdated",
    "Owned Libraries": "Librerie di propriet\u00e0",
    "Owner": "Proprietario",
    "Owner can use admin panel in an organization, must be a new account.": "Il proprietario pu\u00f2 utilizzare il pannello di amministrazione in una organizzazione, deve essere un nuovo account.",
    "Packaging...": "Creazione del file zip in corso...",
    "Page name": "Page name",
    "Pages": "Pagine",
    "Parent folder": "Parent folder",
    "Password": "Password",
    "Password again": "Ridigita password",
    "Password cannot be blank": "Password non pu\u00f2 essere vuota",
    "Password is too short": "La password \u00e8 troppo corta",
    "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols": "La password deve essere lunga almeno 8 caratteri e contenere caratteri diversi: lettere maiuscole, lettere minuscole, numeri e simboli speciali",
    "Password removed": "Password removed",
    "Password reset": "Password reset",
    "Password set": "Password set",
    "Password strength": "Robustezza della password",
    "Password updated": "Password updated",
    "Passwords do not match.": "Le password non corrispondono.",
    "Passwords don't match": "Le Password non corrispondono",
    "Path": "Path",
    "Per 4 hours": "Per 4 ore",
    "Per day": "Per giorno",
    "Per hour": "Per ora",
    "Per week": "Per settimana",
    "Permission": "Permesso",
    "Permission denied": "Permesso negato.",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "Autorizzazione negata. Prova ad accedere nuovamente con {placeholder-left}. {placeholder-right}",
    "Permission name": "Nome permesso",
    "Person image": "Person image",
    "Picture": "Picture",
    "Pictures and videos": "Pictures and videos",
    "Platform": "Piattaforma",
    "Please check the network.": "Si prega di controllare la configurazione di rete.",
    "Please choose a .sdoczip file.": "Please choose a .sdoczip file.",
    "Please choose a .xlsx file.": "Si prega di scegliere un file .xlsx",
    "Please choose an image file.": "Scegli un file immagine.",
    "Please enter 1 or more character": "Prego inserire 1 o pi\u00f9 caratteri",
    "Please enter a new password": "Si prega di inserire una nuova password",
    "Please enter a non-negative integer": "Prego inserire un intero non negativo",
    "Please enter a password.": "Inserisci una password.",
    "Please enter a positive integer": "Inserisci un numero intero positivo",
    "Please enter an integer bigger than 1 as number of links.": "Inserisci un numero intero maggiore di 1 come numero di collegamenti",
    "Please enter an integer not bigger than {max_number} as number of links.": "Inserisci un numero intero non maggiore di {max_number} come numero di collegamenti.",
    "Please enter days": "Prego inserire i giorni",
    "Please enter password": "Per favore, inserisci la password",
    "Please enter the new password again": "Si prega di inserire nuovamente la nuova password",
    "Please enter the old password": "Si prega di inserire la vecchia password",
    "Please enter the password again": "Si prega di inserire nuovamente la password",
    "Please input at least an email.": "Per favore inserisci almeno un'email.",
    "Please select a file": "Prego selezionare un file",
    "Please select a library to share.": "Seleziona una libreria da condividere.",
    "Please select an expiration time": "Seleziona una data di scadenza",
    "Please upload no more than {maxFiles} files at a time.": "Carica non pi\u00f9 di {maxFiles} file alla volta.",
    "Predefined properties": "Propriet\u00e0 predefinite",
    "Preparing to upload...": "Preparazione al caricamento...",
    "Preset hide properties": "Propriet\u00e0 nascoste preimpostate",
    "Preview and download": "Anteprima e scarica",
    "Preview online": "Anteprima online",
    "Preview only": "Solo Anteprima",
    "Previous": "Precedente",
    "Previous (Left arrow key)": "Precedente (tasto freccia sinistra)",
    "Print": "Stampa",
    "Professional Edition": "Versione Professionale",
    "Profile": "Profilo",
    "Profile Setting": "Settaggi del profilo",
    "Properties": "Properties",
    "Property name": "Nome della propriet\u00e0",
    "Publish": "Pubblica",
    "Publish Wiki": "Publish Wiki",
    "Published": "Pubblicato",
    "Quota": "Quota",
    "Quota is invalid.": "Quota non valida.",
    "Rate": "Rate",
    "Read-Only": "Sola lettura",
    "Read-Only folder": "Cartella in sola lettura",
    "Read-Only library": "Libreria in Lettura-Scrittura",
    "Read-Write": "Lettura-Scrittura",
    "Read-Write folder": "Cartella in Lettura-Scrittura",
    "Read-Write library": "Libreria in Lettura-Scrittura",
    "Really want to delete this group?": "Vuoi davvero eliminare questo gruppo?",
    "Really want to delete your account?": "Vuoi veramente eliminare il tuo account?",
    "Really want to leave this group?": "Vuoi davvero lasciare questo gruppo?",
    "Recognizing portraits. Please refresh the page later.": "Recognizing portraits. Please refresh the page later.",
    "Refresh": "Aggiornare",
    "Remaining": "Rimanente",
    "Remove": "Rimuovi",
    "Removed all items from trash.": "Rimossi tutti gli elementi dal cestino.",
    "Removed items older than {n} days from trash.": "Rimossi dal cestino gli elementi pi\u00f9 vecchi di {n} giorni.",
    "Rename": "Rinomina",
    "Rename Department": "Rinominare Dipartimento",
    "Rename File": "File Rinominato",
    "Rename Folder": "Cartella Rinominata",
    "Rename Group": "Rinomina Gruppo",
    "Rename Wiki": "Rinomina Wiki",
    "Rename file": "Rename file",
    "Rename folder": "Rename folder",
    "Rename group to": "Rinomina gruppo in ",
    "Rename property": "Rename property",
    "Renamed file": "File rinominato",
    "Renamed folder": "Cartella rinominata",
    "Renamed library": "Libreria Rinominata",
    "Renamed or Moved files": "File rinominati o spostati",
    "Renaming {name} failed": "Renaming {name} failed",
    "Replace": "Sostituire",
    "Replace file {filename}?": "Sostituisci il file {filename}?",
    "Replacing it will overwrite its content.": "Sotituirlo sovrascriver\u00e0 il suo contenuto.",
    "Report Abuse": "Segnala abuso",
    "Reporter": "Reporter",
    "Reports": "Resoconti",
    "Required at least three letters.": "Required at least three letters.",
    "Reset": "Reset",
    "Reset Password": "Cambia Password",
    "Reset WebDAV Password": "Reimposta la password WebDAV",
    "Reset library password": "Reimposta la password della libreria",
    "ResetPwd": "Ripristina Password",
    "Resetting user's password, please wait for a moment.": "Resetting user's password, please wait for a moment.",
    "Restore": "Ripristina",
    "Restore Library": "Ripristina Libreria",
    "Restored file": "File recuperato",
    "Restored folder": "Cartella recuperata",
    "Restored library": "Liberaria recuperata",
    "Restored {name}": "Restored {name}",
    "Restored {name} and {n} other items": "Restored {name} and {n} other items",
    "Result": "Risultato",
    "Retry": "Riprova",
    "Retry All": "Riprova tutti",
    "Revoke Access": "Accesso Revocato",
    "Revoke Admin": "Revoca l'amministratore",
    "Role": "Ruolo",
    "SAML config": "SAML config",
    "SAML config updated": "SAML config updated",
    "Save": "Salvare",
    "Save Selected Items": "Save Selected Items",
    "Save as ...": "Salva con nome ...",
    "Save to:": "Salva in:",
    "Saving...": "Salvataggio...",
    "Scan the QR code to view the shared content directly": "Scansiona il codice QR per visualizzare direttamente il contenuto condiviso",
    "SeaTable integration": "Integrazione di SeaTable",
    "Seafile": "Seafile",
    "Search": "Ricerca",
    "Search Groups": "Search Groups",
    "Search Libraries": "Search Libraries",
    "Search Organizations": "Search Organizations",
    "Search Users": "Search Users",
    "Search collaborator": "Search collaborator",
    "Search collaborators": "Cerca collaboratori",
    "Search files": "Ricerca files",
    "Search files in this library": "Ricerca documenti in questa libreria",
    "Search group members": "Cerca membri del gruppo",
    "Search groups": "Cerca gruppi",
    "Search groups by name": "Search groups by name",
    "Search libraries by name or ID": "Search libraries by name or ID",
    "Search libraries by owner": "Search libraries by owner",
    "Search option": "Opzioni di ricerca",
    "Search organizations": "Search organizations",
    "Search property": "Search property",
    "Search property types": "Cerca tipi di propriet\u00e0",
    "Search results visited recently": "Risultati di ricerca visitati di recente",
    "Search users": "Ricerca utenti",
    "Search users...": "Cerca utenti...",
    "Select File": "Seleziona il file",
    "Select Image": "Seleziona Immagine",
    "Select Tags": "Seleziona i tag",
    "Select a color": "Seleziona un colore",
    "Select a department": "Seleziona un dipartimento",
    "Select a server": "Seleziona il server",
    "Select a user": "Seleziona un utente",
    "Select a user as admin": "Seleziona un utente come amministratore",
    "Select all": "Select all",
    "Select all items": "Seleziona tutti gli elementi",
    "Select an option": "Select an option",
    "Select collaborators": "Select collaborators",
    "Select libraries to share": "Selezione le librerie da condividere",
    "Select option(s)": "Select option(s)",
    "Select this item": "Seleziona questo elemento",
    "Select up to 50 files": "Select up to 50 files",
    "Send": "Invia",
    "Send activation Email after user registration.": "Invia l'email di attivazione dopo la registrazione dell'utente.",
    "Send to:": "Spedisci a:",
    "Sending new password...": "Invio nuova password...",
    "Sending...": "Invio...",
    "Server": "Server",
    "Server Version: ": "Versione Server:",
    "Set Admin": "Imposta amministratore",
    "Set Contact Email": "Set Contact Email",
    "Set Download Rate Limit": "Imposta il limite di velocit\u00e0 di download",
    "Set Login ID": "Set Login ID",
    "Set Name": "Imposta il Nome",
    "Set Password": "Imposta Password",
    "Set Quota": "Imposta Quota",
    "Set Upload Rate Limit": "Imposta il limite di velocit\u00e0 di caricamento",
    "Set WebDAV Password": "Imposta la password WebDAV",
    "Set access scope": "Imposta l'ambito di accesso",
    "Set max number of members": "Imposta il numero massimo di membri",
    "Set password": "Imposta la password",
    "Set permission": "Imposta permessi",
    "Set permission of {placeholder}": "Imposta l'autorizzazione per {placeholder}",
    "Set quota": "Imposta la quota",
    "Set to current": "Imposta a corrente",
    "Set user contact email": "Imposta email di riferimento per l'utente",
    "Set user default quota": "Imposta la quota predefinita dell'utente",
    "Set user name": "Imposta il nome utente\"",
    "Set user quota": "Imposta la quota dell'utente",
    "Setting library history is disabled by Admin.": "L'impostazione della cronologia delle librerie \u00e8 disabilitata dall'amministratore.",
    "Settings": "Impostazioni",
    "Share": "Condividi",
    "Share Admin": "Amministrazione Condivisioni",
    "Share From": "Condividi Da",
    "Share Link": "Condividi Collegamento",
    "Share Link Traffic": "Condivisione Link del Traffico",
    "Share Links": "Link condivisi",
    "Share To": "Condiviso con",
    "Share To:": "Share To:",
    "Share existing libraries": "Condividi le librerie esistenti",
    "Share link download": "Condividi il link per scaricare",
    "Share link is copied to the clipboard.": "Il link di condivisione viene copiato negli appunti.",
    "Share link upload": "Condividi il link  di caricamento",
    "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.": "Non \u00e8 possibile generare link di condivisione perch\u00e9 in alcune cartella(e) della libreria \u00e8 impostato come \"Invisibile\", \"Lettura-scrittura online\" o \"Sola lettura online\".",
    "Share to group": "Condividi con il gruppo",
    "Share to other server": "Condividi su un altro server",
    "Share to user": "Condividi con l'utente",
    "Shared By": "Condiviso da",
    "Shared Libraries": "Librerie condivise",
    "Shared Links": "Collegamenti condivisi",
    "Shared by:": "Condiviso da:",
    "Shared by: ": "Condiviso da:",
    "Shared with all": "Condivisi con tutti",
    "Shared with me": "Condivisi con me",
    "Show": "Visualizza",
    "Show Codes": "Mostra codici",
    "Show all": "Show all",
    "Show changes": "Show changes",
    "Side Nav Menu": "Menu laterale di navigazione",
    "Single select": "Selezione singola",
    "Site name used in email sending": "Nome del sito utilizzato nell'invio di e-mail",
    "Site title shown in a browser tab": "Titolo del sito mostrato nella scheda del browser",
    "Size": "Dimensione",
    "Social Login": "Login Social",
    "Sort": "Ordinamento",
    "Sort ascending": "Sort ascending",
    "Sort descending": "Sort descending",
    "Space Used": "Spazio Utilizzato",
    "Space Used / Quota": "Spazio utilizzato / Quota",
    "Specific people with email address": "Persone specifiche con indirizzo email",
    "Specific users in the team": "Utenti specifici nel team",
    "Star": "Marca",
    "Start date": "Data di inizio",
    "Statistic": "Statistiche",
    "Status": "Stato",
    "Status: enabled": "Stato: abilitato",
    "Storage": "Storage",
    "Storage Backend": "Backend di archiviazione",
    "Storage Used": "Archivio utilizzato",
    "Style": "Style",
    "Submit": "Invia",
    "Success": "Successo",
    "Successfully added %s.": "%s aggiunto con successo.",
    "Successfully added label(s) for library {placeholder}": "Etichett(a/e) libreria {placeholder} aggiunta/e con successo",
    "Successfully change the group": "Successfully change the group",
    "Successfully changed library password.": "Password della biblioteca modificata con successo.",
    "Successfully cleared trash.": "Successfully cleared trash.",
    "Successfully converted the file.": "Successfully converted the file.",
    "Successfully copied %(name)s and %(amount)s other items.": "%(name)s copiato con successo e %(amount)s altri articoli.",
    "Successfully copied %(name)s and 1 other item.": "%(name)s copiato con successo e 1 altro elemento.",
    "Successfully copied %(name)s.": "%(name)sCopiato con successo.",
    "Successfully copied files to another library.": "Successfully copied files to another library.",
    "Successfully deleted 1 item": "1 elemento rimosso con successo",
    "Successfully deleted 1 item.": "1 oggetto Eliminato con successo.",
    "Successfully deleted 1 share link": "Eliminato 1 link di condivisione con successo",
    "Successfully deleted 1 user.": "Successfully deleted 1 user.",
    "Successfully deleted {name}": "Successfully deleted {name}",
    "Successfully deleted {name} and {n} other items": "Successfully deleted {name} and {n} other items",
    "Successfully deleted {name} and {n} other items.": "Successfully deleted {name} and {n} other items.",
    "Successfully deleted {name}.": "{name} eliminato correttamente.",
    "Successfully deleted {number_placeholder} share links": "Link di condivisione {number_placeholder} eliminati correttamente",
    "Successfully deleted {user_number_placeholder} users.": "Successfully deleted {user_number_placeholder} users.",
    "Successfully edited labels.": "Etichette modificate con successo.",
    "Successfully invited %(email) and %(num) other people.": "Invitato con successo %(email) e %(num) altre persone.",
    "Successfully invited %(email).": "Invitato con successo %(email).",
    "Successfully moved %(name)s and %(amount)s other items.": "%(name)s spostato con successo e %(amount)s altri articoli.",
    "Successfully moved %(name)s and 1 other item.": "%(name)s spostato con successo e 1 altro elemento.",
    "Successfully moved %(name)s.": "%(name)s spostato con successo. ",
    "Successfully moved files to another library.": "Successfully moved files to another library.",
    "Successfully moved {name}.": "Successfully moved {name}.",
    "Successfully restored the library {library_name}.": "Ripristino della libreria {library_name} riuscito.",
    "Successfully restored the library.": "Libreria ripristinata con successo.",
    "Successfully restored.": "Successfully restored.",
    "Successfully revoke the admin permission of %s": "Permessi di amministrazione revocati a %s correttamente",
    "Successfully revoked access of user {placeholder}.": "Accesso revocato all'utente {placeholder}.",
    "Successfully revoked the admin permission of {placeholder}.": "Successfully revoked the admin permission of {placeholder}.",
    "Successfully saved": "Salvato con successo",
    "Successfully sent to {placeholder}": "Inviato con successo a {placeholder}",
    "Successfully set %s as admin.": "%s \u00e8 stato correttamente impostato come amministratore correttamente.",
    "Successfully set it.": "Impostalo con successo.",
    "Successfully set library history.": "Impostare correttamente la cronologia della libreria.",
    "Successfully starred {library_name_placeholder}.": "{library_name_placeholder} selezionato con successo.",
    "Successfully transferred the group.": "Gruppo trasferito con successo.",
    "Successfully transferred the library.": "Libreria trasferita con successo.",
    "Successfully unlinked %(name)s.": "Scollegamento riuscito%(name)s.",
    "Successfully unlinked the device.": "Successfully unlinked the device.",
    "Successfully unshared library {placeholder}": "Condivisione della libreria {placeholder} annullata con successo",
    "Successfully unshared {name}": "Successfully unshared {name}",
    "Successfully unstarred {library_name_placeholder}.": "{library_name_placeholder} deselezionato con successo.",
    "Suggestion": "Suggestion",
    "Switch sort mode": "Cambia la modalit\u00e0 di ordinamento",
    "Switch to plain text editor": "Switch to plain text editor",
    "Switch to rich text editor": "Switch to rich text editor",
    "Switch view mode": "Cambia modalit\u00e0 di visualizzazione",
    "Sync": "Sincronizza",
    "Sync Download": "Sincronizzare il Download",
    "Sync Traffic": "Sincronizzazione Traffico",
    "Sync Upload": "Sincronizzare il Caricamento",
    "System": "Sistema",
    "System Admin": "Amministratore del Sistema",
    "System Info": "Informazioni di Sistema",
    "System settings updated": "System settings updated",
    "Table": "Tabella",
    "Tag \"{name}\" already exists.": "Il Tag \"{name}\" esiste gi\u00e0.",
    "Tag not found": "Etichetta non trovata",
    "Tagged Files": "File contrasseganti",
    "Tags": "Tag",
    "Tags imported": "Etichette importate",
    "Team name": "Team name",
    "Template": "Modello",
    "Terms": "Termini",
    "Terms and Conditions": "Termini e Condizioni",
    "Text": "Testo",
    "Text is required.": "Il testo \u00e8 obbligatorio.",
    "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved": "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved",
    "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved": "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved",
    "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.": "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.",
    "The file is too large. Allowed maximum size is 1MB.": " Il file \u00e8 troppo grande. La dimensione massima consentita \u00e8 1 MB.",
    "The imported options are invalid": "The imported options are invalid",
    "The imported tag already exists": "L'etichetta importata esiste gi\u00e0",
    "The imported tags are invalid": "Le etichette importate non sono valide",
    "The least number of characters a share/upload link password should include.": "The least number of characters a share/upload link password should include.",
    "The least number of characters an encrypted library password should include.": "Il numero minimo di caratteri di una password che una libreria crittografata dovrebbe contenere",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols",
    "The link is copied to the clipboard.": "Il link viene copiato negli appunti.",
    "The list of added, deleted and modified files will be sent to your mailbox.": "L'elenco dei file aggiunti, eliminati e modificati verr\u00e0 inviato alla tua casella di posta.",
    "The maximum number of failed login attempts before showing CAPTCHA.": "Il numero massimo di tentativi di accesso non riusciti prima di mostrare CAPTCHA.",
    "The name \"{name}\" is already taken. Please choose a different name.": "Il nome \"{name}\" risulta gi\u00e0 utilizzato. Prego scegliere un nome differenze.",
    "The next month": "Il prossimo mese",
    "The next numbers of days": "I prossimi numeri di giorni",
    "The next week": "La prossima settimana",
    "The next year": "Il prossimo anno",
    "The owner of this library has run out of space.": "Il proprietario di questa libreria non ha pi\u00f9 spazio a disposizione.",
    "The password is too short.": "La password \u00e8 troppo corta.",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": " La password \u00e8 troppo debole. Dovrebbe includere almeno {passwordStrengthLevel} dei seguenti caratteri: numero, lettere maiuscole, lettere minuscole e altri simboli speciali.",
    "The password will be kept in the server for only 1 hour.": "La password \u00e8 conservata nel server per solo 1 ora.",
    "The past month": "Il mese scorso",
    "The past numbers of days": "Il numero di giorni passati",
    "The past week": "La settimana scorsa",
    "The past year": "L'anno scorso",
    "There is another option with this name": "There is another option with this name",
    "There is another property with this name": "There is another property with this name",
    "There is no information to display.": "There is no information to display.",
    "This file has (apparently) not been accessed yet": "Questo file (apparentemente) non \u00e8 stato ancora visitato",
    "This file has been updated.": "Questo file \u00e8 stato aggiornato.",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": " Questa cartella \u00e8 stata condivisa con {user_amount} user(s) e {group_amount} group(s).",
    "This folder has no content at this time.": "Questa cartella adesso non ha contenuti.",
    "This is a special group representing a department.": "Questo \u00e8 un gruppo speciale che rappresenta un dipartimento.",
    "This is required": "Questo \u00e8 necessario",
    "This library has been set to read-only by admin and cannot be updated.": "This library has been set to read-only by admin and cannot be updated.",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": " Questa libreria \u00e8 stata condivisa con {user_amount} utemte(i) e {group_amount} group(s).",
    "This library is password protected": "Questa libreria \u00e8 protetta da password",
    "This month": "Questo mese",
    "This operation will not be reverted. Please think twice!": "Questa operazione non sar\u00e0 reversibile. Per cortesia pensaci due volte!",
    "This property can not be deleted": "This property can not be deleted",
    "This property does not support sorting": "This property does not support sorting",
    "This property is not editable": "This property is not editable",
    "This user has not created or joined any groups": "Questo utente non ha creato o aggiunto alcun gruppo",
    "This week": "Questa settimana",
    "This year": "Questo anno",
    "Thumbnail": "Miniatura",
    "Time": "Orario",
    "Tip: -2 means no limit.": "Suggerimento: -2 significa nessun limite.",
    "Tip: 0 means default limit": "Suggerimento: 0 significa limite predefinito",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Suggerimento: verr\u00e0 generata un'istantanea dopo la modifica, che registra lo stato della libreria dopo la modifica.",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "Suggerimento: le librerie eliminate {placeholder} giorni fa verranno rimosse automaticamente.",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.",
    "Tip: you can search by keyword in name or ID.": "Tip: you can search by keyword in name or ID.",
    "Tip: you can search by keyword in name.": "Suggerimento: puoi cercare per parola chiave nel nome.",
    "Today": "Oggi",
    "Token": "Simbolo",
    "Token:": "Token:",
    "Tomorrow": "Domani",
    "Too many requests": "Too many requests",
    "Total Devices": "Dispositivi Totali",
    "Total Storage": "Archiviazione totale",
    "Total Traffic": "Traffico Totale",
    "Total Users": "Utenti totali",
    "Traffic": "Traffico",
    "Transfer": "Trasferisci",
    "Transfer Group": "Trasferisci Gruppo",
    "Transfer Group {placeholder} to": "Trasferisci gruppo {placeholder} a",
    "Transfer Library": "Trasferisci Libreria",
    "Transfer Library {library_name}": "Trasferimento Libreria {library_name}",
    "Transfer group to": "Trasferisci al gruppo",
    "Transfer to department": "Trasferimento al dipartimento",
    "Transfer to user": "Trasferimento all'utente",
    "Transferred group {group_name} from {user_from} to {user_to}": "Gruppo {group_name} trasferito da {user_from} a {user_to}",
    "Transferred library {library_name} from {user_from} to {user_to}": "Libreria {library_name} trasferita da {user_from} a {user_to}",
    "Trash": "Cestino",
    "Turn off": "Spegnere",
    "Turn off extended properties": "Disattiva le propriet\u00e0 estese",
    "Turn on extensible properties and views to experience a new way of managing files": "Turn on extensible properties and views to experience a new way of managing files",
    "Two-Factor Authentication": "Autenticazione a due fattori",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "L'autenticazione a due fattori non \u00e8 abilitata per il tuo account. Abilita l'autenticazione a due fattori per una maggiore sicurezza degli account.",
    "Type": "Tipo",
    "Type characters to start search": "Digita alcini caratteri per avviare la ricerca",
    "URL is copied to the clipboard": "URL is copied to the clipboard",
    "URL is required": "URL is required",
    "US": "US",
    "Undo": "Undo",
    "Unfold the sidebar": "Apri la barra laterale",
    "Unfreeze Document": "Unfreeze Document",
    "Unhandled": "Unhandled",
    "Unknown": "Sconosciuto",
    "Unlink": "Scollega",
    "Unlink device": "Scollega dispositivo",
    "Unlock": "Sbloccato",
    "Unpublish": "Annulla pubblicazione",
    "Unpublish Wiki": "Annulla pubblicazione Wiki",
    "Unselect": "Deseleziona",
    "Unselect all items": "Deseleziona tutti gli elementi",
    "Unselect this item": "Deseleziona questo elemento",
    "Unshare": "Elimina condivisione",
    "Unshare Library": "Annulla condivisione libreria",
    "Unstar": "Smarca",
    "Untitled": "Untitled",
    "Unwatch File Changes": "Non consultare le modifiche ai file",
    "Up": "Up",
    "Update": "Aggiorna",
    "Update Terms and Conditions": "Aggiorna termini e condizioni",
    "Update password": "Aggiorna la password",
    "Update succeeded.": "Update succeeded.",
    "Updated draft": "Bozza aggiornata",
    "Updated file": "File aggiornato",
    "Upgrade to Pro Edition": "Esegui l'avanzamento alla versione professionale",
    "Upload": "Carica",
    "Upload Files": "Carica File",
    "Upload Folder": "Carica cartella",
    "Upload Link": "Link di Upload",
    "Upload Links": "Link di Upload",
    "Upload file": "Carica file",
    "Upload files to {folder_name_placeholder}": "Upload files to {folder_name_placeholder}",
    "Upload license": "Upload license",
    "Upload link is copied to the clipboard.": "Il link di caricamento viene copiato negli appunti.",
    "Uploaded": "Caricato",
    "Uploading...": "Caricamento...",
    "Use custom CSS": "Utilizza CSS personalizzato",
    "Use information from your Identity Provider to configure Seafile": "Use information from your Identity Provider to configure Seafile",
    "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.": "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.",
    "Use the import/export function to transfer tags quickly to another library. (The export is in JSON format.)": "Utilizza la funzione di importazione/esportazione per trasferire rapidamente le etichette in un'altra libreria. (L'esportazione \u00e8 in formato JSON.)",
    "Use these values to configure your Identity Provider": "Use these values to configure your Identity Provider",
    "Used:": "Utilizzato:",
    "User": "Utente",
    "User Email": "Email utente",
    "User Permission": "Permessi Utente",
    "User Shares": "Condivisioni degli utenti",
    "User Storage": "Archiviazione degli utenti",
    "User can not see this folder.": "User can not see this folder.",
    "User can only view files online via browser. Files can't be downloaded.": "L'utente pu\u00f2 solo visualizzare i file online tramite browser. I file non possono essere scaricati.",
    "User can read, download and sync files.": "L'utente pu\u00f2 leggere, scaricare e sincronizzare i file.",
    "User can read, write, upload, download and sync files.": "L'utente pu\u00f2 leggere, scrivere, caricare, scaricare e sincronizzare i file.",
    "User can view and edit file online via browser. Files can't be downloaded.": "User can view and edit file online via browser. Files can't be downloaded.",
    "User info updated": "User info updated",
    "User migrate from {user_from} to {user_to}": "User migrate from {user_from} to {user_to}",
    "User not found": "Utente non trovato",
    "User {user_link} has added you to {group_link}": "L'utente {user_link} ti ha aggiunto a {group_link}",
    "Username:": "Nome utente:",
    "Users": "Utenti",
    "Verified": "Verified",
    "Verify": "Verifica",
    "Verify Domain": "Verify Domain",
    "Version": "Versione",
    "Version Number": "Numero della versione",
    "Version Number is required.": "Il numero di versione \u00e8 obbligatorio.",
    "Version Number must be a number.": "Il numero di versione deve essere un numero.",
    "Video": "Video",
    "View": "Vedi",
    "View Link": "View Link",
    "View Related Snapshot": "View Related Snapshot",
    "View Snapshot": "Visualizza Istantanea",
    "View all notifications": "Visualizza tutte le notifiche",
    "View profile and more": "Consulta il profilo e le altre impostazioni",
    "Views": "Viste",
    "Virus": "Virus",
    "Virus File": "File infetto",
    "Virus Scan": "Scansione Virus",
    "Visit count": "Visit count",
    "Visit old version page": "Visita la vecchia versione della pagina",
    "Visited": "Visitato",
    "Visits": "Visite",
    "Waiting...": "In attesa...",
    "Watch File Changes": "Consulta le modifiche ai file",
    "Web API Auth Token": "Token di autenticazione API via Web",
    "Web Download": "Download via Web",
    "Web Traffic": "Traffico Web",
    "Web Upload": "Caricamento via Web",
    "WebDAV Access": "Accesso WebDAV",
    "WebDAV password:": "Password WebDAV:",
    "WebDAV username:": "None utente WebDAV:",
    "Welcome to {site_name_placeholder}": "Benvenuto su {site_name_placeholder}",
    "Whether the notifications of collaboration such as sharing library or joining group should be sent to your mailbox.": "Se le notifiche di collaborazione come la condivisione della libreria o l'adesione al gruppo devono essere inviate alla tua casella di posta.",
    "Wiki custom URL deleted": "Wiki custom URL deleted",
    "Wiki owner": "Proprietario del Wiki",
    "Wiki published": "Wiki published",
    "Wikis": "Wiki",
    "Workspace": "Spazio di lavoro",
    "Wrong password": "Password sbagliata",
    "Year": "Year",
    "Yesterday": "Ieri",
    "You are watching file changes of this library.": "Stai guardando le modifiche ai file di questa libreria.",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "Puoi anche aggiungere come guest, egli non potr\u00e0 creare librerie o gruppi.",
    "You can create files quickly": "Puoi creare file rapidamente",
    "You can enter multiple emails. An invitation link will be sent to each of them.": " Puoi inserire pi\u00f9 email. A ciascuno di loro verr\u00e0 inviato un link di invito.",
    "You can use this field at login.": "Puoi usare questo campo al login.",
    "You do not have any Wikis yet.": "You do not have any Wikis yet.",
    "You do not have permission": "You do not have permission",
    "You don't have any favorite items yet": "You don't have any favorite items yet",
    "You don't have any share links": "Non hai collegamenti di condivisione",
    "You don't have any upload links": "Non hai nessun link per il caricamento",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "Non hai eliminato alcuna libreria negli ultimi {placeholder} giorni. Una libreria eliminata verr\u00e0 pulita automaticamente dopo questo periodo.",
    "You have not shared any folders": "Non hai condiviso alcuna cartella",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".",
    "You have only one backup code remaining.": "Ti rimane un solo codice di backup.",
    "You have {num} backup codes remaining.": "Ti restano {num} codici di backup.",
    "Your notifications will be sent to this email.": "Le tue notifiche verranno inviate a questa email.",
    "ZIP": "ZIP",
    "Zoom in": "Ingrandire",
    "Zoom out": "Rimpicciolire",
    "all": "tutto/i",
    "all members": "tutti i membri",
    "contains": "contiene",
    "days": "giorni",
    "deleted": "cancellato",
    "deleted option": "deleted option",
    "details": "details",
    "does not contain": "non contiene",
    "email is required": "\u00e8 richiesta l'email",
    "freezed": "congelato",
    "has all of...": "ha tutti di...",
    "has any of...": "ha qualcuno di...",
    "has none of...": "non ha nessuno di...",
    "icon": "icona",
    "in all libraries": "in tutte le librerie",
    "in this folder": "in questa cartella",
    "in this library": "in questa libreria",
    "include the current user": "includere l'utente corrente",
    "is": "\u00e8",
    "is after...": "\u00e8 dopo...",
    "is any of...": "\u00e8 uno qualsiasi di...",
    "is before...": "\u00e8 prima...",
    "is current user's ID": "\u00e8 l'ID dell'utente corrente",
    "is empty": "\u00e8 vuoto",
    "is exactly...": "\u00e8 esattamente...",
    "is none of...": "non \u00e8 nessuno di...",
    "is not": "non \u00e8",
    "is not empty": "non \u00e8 vuoto",
    "is on or after...": " \u00e8 adesso o dopo...",
    "is on or before...": "\u00e8 adesso o prima...",
    "is within...": "\u00e8 dentro...",
    "items": "items",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}",
    "locked": "bloccato",
    "locked by {name}": "Bloccato da {name}",
    "mm": "mm",
    "name": "nome",
    "not set": "non impostato",
    "only show {placeholder}": "only show {placeholder}",
    "progress": "avanzamento",
    "s": "s",
    "selected": "selezionato",
    "shared by:": "condiviso da:",
    "show more": "mostra di pi\u00f9",
    "size": "dimensione",
    "sorts": "ordinamenti",
    "starred": "preferiti",
    "state": "stato",
    "successfully added user %s.": "successfully added user %s.",
    "successfully sent email to %s.": "successfully sent email to %s.",
    "unstarred": "non preferiti",
    "xxx cells copied": "xxx cells copied",
    "xxx cells selected": "xxx cells selected",
    "xxx record": "xxx record",
    "xxx records": "xxx records",
    "xxx records selected": "xxx records selected",
    "xxx rows are copied.": "xxx rows are copied.",
    "{failed_files_num} file(s) failed to upload": "{failed_files_num} file(s) caricamento non riuscito",
    "{file} and {n} other files": "{file} and {n} other files",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} giorni",
    "{number_placeholder} / Page": "{number_placeholder} / Pagina",
    "{placeholder} API Token": "Token API {placeholder}",
    "{placeholder} Access Log": "{placeholder} Access Log",
    "{placeholder} Folder Permission": "{placeholder} Permesso cartella",
    "{placeholder} History Setting": "{placeholder} Impostazione dello storico",
    "{placeholder} Modification History": "{placeholder} Modification History",
    "{placeholder} Share Admin": "{placeholder} Condividi amministratore",
    "{placeholder} Snapshot": "{placeholder} Snapshot",
    "{placeholder} Trash": "{placeholder} Cestino",
    "{placeholder} Wiki Trash": "{placeholder} Wiki Trash",
    "{share_from} has cancelled the sharing of folder {repo_name}.": "{share_from} ha annullato la condivisione della cartella {repo_name}.",
    "{share_from} has cancelled the sharing of library {repo_name}.": "{share_from} ha annullato la condivisione della libreria {repo_name}.",
    "{share_from} has changed the permission of folder {repo_link} to {permission}.": "{share_from} ha cambiato i permessi della cartella {repo_link} in {permission}.",
    "{share_from} has changed the permission of library {repo_link} to {permission}.": "{share_from} ha cambiato l'autorizzazione della libreria {repo_link} in {permission}.",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from} ha condiviso una cartella denominata {repo_link} con il gruppo {group_link}.",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} ha condiviso con te una cartella denominata {repo_link}.",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from} ha condiviso una libreria denominata {repo_link} nel gruppo {group_link}.",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} ha condiviso con te una libreria denominata {repo_link}.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. However, since you are a guest user now, you can not create libraries.": "{site_name_placeholder}  organizza i file in librerie. Ogni libreria pu\u00f2 essere sincronizzata e condivisa separatamente. Tuttavia, poich\u00e9 ora sei un utente ospite, non puoi creare librerie.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. We have created a personal library for you. You can create more libraries later.": "{site_name_placeholder}  organizza i file in librerie. Ogni libreria pu\u00f2 essere sincronizzata e condivisa separatamente. Abbiamo creato per te una libreria personale. Puoi creare pi\u00f9 librerie in un secondo momento.",
    "{uploaded_files_num}/{all_files_num} Files": "{uploaded_files_num}/{all_files_num} Files",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} ha creato il file {fileName} e {fileCount} altro/i file(s) nella libreria {libraryName}.",
    "{user} created file {fileName} in library {libraryName}.": "{user} ha creato il file {fileName} nella libreria {libraryName}.",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} ha creato la cartella {folderName} e {folderCount} altra/e cartella(e) nella libreria {libraryName}.",
    "{user} created folder {folderName} in library {libraryName}.": "{user} ha creato la cartella {folderName} nella libreria {libraryName}.",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} a rimosso il file {fileName} e {fileCount} altro/i file(s) nella libreria {libraryName}.",
    "{user} deleted file {fileName} in library {libraryName}.": "{user} ha eliminato il file {fileName} nella libreria {libraryName}.",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} ha rimosso la cartella {folderName} e {folderCount} altra/e cartella(e) nella libreria {libraryName}.",
    "{user} deleted folder {folderName} in library {libraryName}.": "{user} ha rimosso la cartella {folderName} nella libreria {libraryName}.",
    "{user} has transfered a library named {repo_link} to you.": "{user} ti ha trasferito una libreria denominata {repo_link}.",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} ha spostato il file {fileName} e {fileCount} altro/i file(s) nella libreria {libraryName}.",
    "{user} moved file {fileName} in library {libraryName}.": "{user} ha spostato il file {fileName} nella libreria {libraryName}.",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} ha spostato la cartella {folderName} e {folderCount} altra/e cartella(e) nella libreria {libraryName}.",
    "{user} moved folder {folderName} in library {libraryName}.": "{user} ha spostato la cartella {folderName} nella libreria {libraryName}.",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "{user} ha rinominato il file {oldFileName} {fileName} nella libreria {libraryName}.",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "{user} ha rinominato la cartella {oldFolderName} {folderName} nella libreria {libraryName}.",
    "{user} restored file {fileName} in library {libraryName}.": "{user} ha ripristinato il file  {fileName} nella libreria {libraryName}.",
    "{user} restored folder {folderName} in library {libraryName}.": "{user} ha ripristinato la cartella {folderName} nella libreria {libraryName}.",
    "{user} updated file {fileName} in library {libraryName}.": "{user} ha aggiornato il file {fileName} nella libreria {libraryName}."
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "l d F Y H:i",
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S",
      "%d/%m/%Y %H:%M:%S.%f",
      "%d/%m/%Y %H:%M",
      "%d/%m/%y %H:%M:%S",
      "%d/%m/%y %H:%M:%S.%f",
      "%d/%m/%y %H:%M",
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%d-%m-%Y %H:%M:%S",
      "%d-%m-%Y %H:%M:%S.%f",
      "%d-%m-%Y %H:%M",
      "%d-%m-%y %H:%M:%S",
      "%d-%m-%y %H:%M:%S.%f",
      "%d-%m-%y %H:%M",
      "%Y-%m-%d"
    ],
    "DATE_FORMAT": "d F Y",
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y",
      "%Y/%m/%d",
      "%d-%m-%Y",
      "%Y-%m-%d",
      "%d-%m-%y",
      "%d/%m/%y"
    ],
    "DECIMAL_SEPARATOR": ",",
    "FIRST_DAY_OF_WEEK": 1,
    "MONTH_DAY_FORMAT": "j F",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "d/m/Y H:i",
    "SHORT_DATE_FORMAT": "d/m/Y",
    "THOUSAND_SEPARATOR": ".",
    "TIME_FORMAT": "H:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

